/*
 * Copyright (c) Doug Palmer <doug@charvolant.org> 2005
 *
 * See LICENSE for licensing details.
 * 
 * $Id$
 */

package org.charvolant.sudoku;

/**
 * A record of where a decision was made that might need
 * to be retracted.
 * 
 * @author doug
 */
public class ChoicePoint {
  /** The trail position */
  private int trail;
  
  public ChoicePoint(int trail) {
    this.trail = trail;
  }

  /**
   * Get the trail position.
   *
   * @return Returns the trail position upon taking this choice point.
   */
  public int getTrail() {
    return this.trail;
  } 
}
