/*
 * Copyright (c) Doug Palmer <doug@charvolant.org> 2005
 *
 * See LICENSE for licensing details.
 * 
 * $Id$
 */

package org.charvolant.sudoku;

/**
 * An entry in the trail.
 * <p>
 * Each entry contains enough information to reset something
 * about a cell.
 * 
 * @author doug
 *
 */
public abstract class TrailEntry {
  /** The trailed cell */
  protected Cell cell;
  
  /**
   * Construct for a specific cell.
   * 
   * @param cell The cell
   */
  public TrailEntry(Cell cell) {
    this.cell = cell;
  }
  
  /**
   * Rewind the cell.
   * <p>
   * Do whatever is needed to turn the cell back
   * to what it was.
   *
   */
  abstract public void rewind();
}
