/*
 * Copyright (c) Doug Palmer <doug@charvolant.org> 2005
 *
 * See LICENSE for licensing details.
 * 
 * $Id$
 */

package org.charvolant.sudoku.gui;

import java.applet.Applet;

import org.charvolant.sudoku.Board;

/**
 * An applet that displays the sudoku solver in a web page.
 * 
 * @author doug
 */
public class SudokuApplet extends Applet {
  /** The name of the size parameter: {@value} */
  public static final String PARAMETER_SIZE = "size";
  /** The minimum size: {@value} */
  public static final int SIZE_MINIMUM = 4;
  /** The maximum size: {@value} */
  public static final int SIZE_MAXIMUM = 25;
  /** The default size: {@value} */
  public static final int SIZE_DEFAULT = 9;
  
  /** The board */
  private Board board;
  /** The board panel */
  private GamePanel gamePanel;
  
  /**
   * The applet information.
   *
   * @return A string describing the applet.
   *
   * @see java.applet.Applet#getAppletInfo()
   */
  @Override
  public String getAppletInfo() {
    return
      "SuDoKu solver applet\n" +
      "An applet that allows you to solve SuDoKu puzzles by keeping track of possible values\n" +
      "Copyright \u00a9 2005 Doug Palmer doug@charvolant.org";
  }

  /**
   * The parameters that we accept
   *
   * @return The parameter information
   *
   * @see java.applet.Applet#getParameterInfo()
   */
  @Override
  public String[][] getParameterInfo() {
    return new String[][] {
        { this.PARAMETER_SIZE, "4,9,16,25", "The size of a square (9 by default)" }
    };
  }

  /**
   * Initialise the applet.
   * <p>
   * Set up the board and the board display.
   *
   * @see java.applet.Applet#init()
   */
  @Override
  public void init() {
    String param;
    int size = this.SIZE_DEFAULT;;
    
    super.init();
    param = this.getParameter(this.PARAMETER_SIZE);
    if (param != null) {
      try {
        size = Integer.parseInt(param);
      } catch (Exception ex) {
        this.showStatus("Unable to read size parameter of " + param);
        size = this.SIZE_DEFAULT;
      }
    }
    if (size < this.SIZE_MINIMUM || size > this.SIZE_MAXIMUM) {
      this.showStatus("Size parameter of " + size + " is out of range");
      size = this.SIZE_DEFAULT;
    }
    this.board = new Board(size);
    this.gamePanel = new GamePanel(this.board);
    this.add(this.gamePanel);
  }
}
